//========================================================================================
//  
//  $File: //depot/indesign_5.0/gm/build/scripts/export as xhtml/startup scripts/XHTMLExportMenuItemLoader.jsx $
//  
//  Owner: Roey Horns
//  
//  $Author: sstudley $
//  
//  $DateTime: 2007/02/15 13:37:33 $
//  
//  $Revision: #1 $
//  
//  $Change: 505969 $
//  
//  Copyright 1997-2007 Adobe Systems Incorporated. All rights reserved.
//  
//  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance 
//  with the terms of the Adobe license agreement accompanying it.  If you have received
//  this file from a source other than Adobe, then your use, modification, or 
//  distribution of it requires the prior written permission of Adobe.
//
//  Purpose: Load and run the XHTML Export Menu Item script
//
//  The XHTML Export Menu Item script needs to run in the session script engine.
//  Binary scripts can't switch to a specfic script engine. Thus we use this
//  uncompiled script to run the XHTML Export Menu Item script in the proper
//  script engine.
//
//==============================================================================

#targetengine "xhtml export"

// don't want to run twice
if(typeof(XHTMLExportMenuItem) == 'undefined') {

	function XHTMLExportMenuItemLoader() {
	}

	//------------------------------------------------------------------------------
	// XHTMLExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------

	XHTMLExportMenuItemLoader.getScriptsFolderPath = function() {
		try {
			var script = app.activeScript;
		} catch(e) {
			// we are running from the ESTK
			var script = File(e.fileName);
		}
		return script.path + '/../';
	} // XHTMLExportMenuItemLoader.getScriptsFolderPath


	//------------------------------------------------------------------------------
	// XHTMLExportMenuItemLoader.loadScript
	//------------------------------------------------------------------------------

	XHTMLExportMenuItemLoader.loadScript = function(filename) {
		var file = File(XHTMLExportMenuItemLoader.getScriptsFolderPath() + filename );
		var	script = undefined;
		if (file.exists) {
			file.open();
			script = file.read();
			file.close();
		}
		// we return the script rather than calling eval() right here
		// because the results of eval() are only valid within the
		// scope of the function that calls eval()
		return script;
	} //XHTMLExportMenuItemLoader.loadScript

	// load the script
	XHTMLExportMenuItemLoader.script = XHTMLExportMenuItemLoader.loadScript('XHTMLExportMenuItem.jsxbin');
	if(XHTMLExportMenuItemLoader.script != undefined) {
		// execute it
		eval(XHTMLExportMenuItemLoader.script);
	}
}